<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml"
                              xmlns:html="http://www.w3.org/1999/xhtml"
                              xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                              xmlns:wwtoc="urn:WebWorks-Engine-TOC-Schema"
                              xmlns:wwlinks="urn:WebWorks-Engine-Links-Schema"
                              xmlns:wwmode="urn:WebWorks-Engine-Mode"
                              xmlns:wwfiles="urn:WebWorks-Engine-Files-Schema"
                              xmlns:wwdoc="urn:WebWorks-Document-Schema"
                              xmlns:wwsplits="urn:WebWorks-Engine-Splits-Schema"
                              xmlns:wwvars="urn:WebWorks-Variables-Schema"
                              xmlns:wwproject="urn:WebWorks-Publish-Project"
                              xmlns:wwpage="urn:WebWorks-Page-Template-Schema"
                              xmlns:wwlocale="urn:WebWorks-Locale-Schema"
                              xmlns:wwprogress="urn:WebWorks-XSLT-Extension-Progress"
                              xmlns:wwlog="urn:WebWorks-XSLT-Extension-Log"
                              xmlns:wwfilesystem="urn:WebWorks-XSLT-Extension-FileSystem"
                              xmlns:wwuri="urn:WebWorks-XSLT-Extension-URI"
                              xmlns:wwstring="urn:WebWorks-XSLT-Extension-StringUtilities"
                              xmlns:wwfilesext="urn:WebWorks-XSLT-Extension-Files"
                              xmlns:wwprojext="urn:WebWorks-XSLT-Extension-Project"
                              xmlns:wwexsldoc="urn:WebWorks-XSLT-Extension-Document"
                              exclude-result-prefixes="xsl msxsl wwtoc wwlinks wwmode wwfiles wwdoc wwsplits wwvars wwproject wwpage wwlocale wwprogress wwlog wwfilesystem wwuri wwstring wwfilesext wwprojext wwexsldoc"
>
 <xsl:param name="GlobalInput" />
 <xsl:param name="GlobalPipelineName" />
 <xsl:param name="GlobalProject" />
 <xsl:param name="GlobalFiles" />
 <xsl:param name="ParameterDependsType" />
 <xsl:param name="ParameterSplitsType" />
 <xsl:param name="ParameterLinksType" />
 <xsl:param name="ParameterType" />
 <xsl:param name="ParameterLocaleType" />
 <xsl:param name="ParameterProjectVariablesType" />
 <xsl:param name="ParameterPageTemplateURI" />
 <xsl:param name="ParameterParcelInfoSplitFileType" />
 <xsl:param name="ParameterCategory" />
 <xsl:param name="ParameterUse" />
 <xsl:param name="ParameterDeploy" />


 <xsl:output encoding="UTF-8" indent="yes" />
 <xsl:namespace-alias stylesheet-prefix="html" result-prefix="#default" />
 <xsl:strip-space elements="*" />


 <xsl:include href="wwtransform:common/companyinfo/companyinfo_content.xsl" />
 <xsl:include href="wwtransform:html/css_properties.xsl" />
 <xsl:include href="wwtransform:common/variables/variables.xsl" />
 <xsl:include href="wwtransform:common/pages/pagetemplate.xsl" />
 <xsl:include href="wwtransform:uri/uri.xsl" />
 <xsl:include href="wwformat:Transforms/connect_utilities.xsl" />


 <xsl:key name="wwfiles-files-by-type" match="wwfiles:File" use="@type" />
 <xsl:key name="wwsplits-files-by-type" match="wwsplits:File" use="@type" />
 <xsl:key name="wwtoc-entries-by-path" match="wwtoc:Entry" use="@path" />


 <xsl:variable name="GlobalActionChecksum">
  <xsl:variable name="VarTransformChecksums">
   <xsl:value-of select="concat(wwuri:AsFilePath('wwtransform:self'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:self')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath($ParameterPageTemplateURI), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath($ParameterPageTemplateURI)))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwtransform:common/companyinfo/companyinfo_content.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:common/companyinfo/companyinfo_content.xsl')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwtransform:html/css_properties.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:html/css_properties.xsl')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwtransform:common/variables/variables.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:common/variables/variables.xsl')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwtransform:common/pages/pagetemplate.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:common/pages/pagetemplate.xsl')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwtransform:uri/uri.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:uri/uri.xsl')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwformat:Transforms/connect_utilities.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwformat:Transforms/connect_utilities.xsl')))" />
  </xsl:variable>
  <xsl:value-of select="wwstring:MD5Checksum($VarTransformChecksums)" />
 </xsl:variable>


 <!-- Locale -->
 <!--        -->
 <xsl:variable name="GlobalLocalePath">
  <xsl:for-each select="$GlobalFiles[1]">
   <xsl:value-of select="key('wwfiles-files-by-type', $ParameterLocaleType)[1]/@path" />
  </xsl:for-each>
 </xsl:variable>
 <xsl:variable name="GlobalLocale" select="wwexsldoc:LoadXMLWithoutResolver($GlobalLocalePath)" />


 <!-- Links -->
 <!--        -->
 <xsl:variable name="GlobalLinksPath">
  <xsl:for-each select="$GlobalFiles[1]">
   <xsl:value-of select="key('wwfiles-files-by-type', $ParameterLinksType)[1]/@path" />
  </xsl:for-each>
 </xsl:variable>
 <xsl:variable name="GlobalLinks" select="wwexsldoc:LoadXMLWithoutResolver($GlobalLinksPath)" />


 <!-- Mapping Entry Sets -->
 <!--                    -->
 <xsl:variable name="GlobalMapEntrySetsPath" select="wwuri:AsFilePath('wwtransform:html/mapentrysets.xml')" />
 <xsl:variable name="GlobalMapEntrySets" select="wwexsldoc:LoadXMLWithoutResolver($GlobalMapEntrySetsPath)" />


 <!-- Page Template -->
 <!--               -->
 <xsl:variable name="GlobalPageTemplatePath" select="wwuri:AsFilePath($ParameterPageTemplateURI)" />
 <xsl:variable name="GlobalPageTemplate" select="wwexsldoc:LoadXMLWithoutResolver($GlobalPageTemplatePath)" />


 <!-- Page template include files -->
 <!--                             -->
 <xsl:variable name="GlobalPageTemplateIncludeFilesAsXML">
  <xsl:apply-templates select="$GlobalPageTemplate" mode="wwmode:pagetemplate-include-files">
   <xsl:with-param name="ParamPageTemplateURI" select="$ParameterPageTemplateURI" />
  </xsl:apply-templates>
 </xsl:variable>
 <xsl:variable name="GlobalPageTemplateIncludeFiles" select="msxsl:node-set($GlobalPageTemplateIncludeFilesAsXML)" />


 <!-- Project variables -->
 <!--                   -->
 <xsl:variable name="GlobalProjectVariablesPath">
  <xsl:for-each select="$GlobalFiles[1]">
   <xsl:value-of select="key('wwfiles-files-by-type', $ParameterProjectVariablesType)[1]/@path" />
  </xsl:for-each>
 </xsl:variable>
 <xsl:variable name="GlobalProjectVariables" select="wwexsldoc:LoadXMLWithoutResolver($GlobalProjectVariablesPath)" />


 <xsl:variable name="GlobalFilenameSpacesToUnderscores" select="wwprojext:GetFormatSetting('filename-spaces-to-underscores') = 'true'" />
 <xsl:variable name="GlobalFilenameSpacesToUnderscoresSearchString">
  <xsl:if test="$GlobalFilenameSpacesToUnderscores">
   <xsl:text> </xsl:text>
  </xsl:if>
 </xsl:variable>
 <xsl:variable name="GlobalFilenameSpacesToUnderscoresReplaceString">
  <xsl:if test="$GlobalFilenameSpacesToUnderscores">
   <xsl:text>_</xsl:text>
  </xsl:if>
 </xsl:variable>

 <xsl:variable name="GlobalInvalidPathCharactersExpression" select="'[#&amp;?]'" />

 <xsl:template match="/">
  <wwfiles:Files version="1.0">

   <!-- Get page template files -->
   <!--                         -->
   <xsl:variable name="VarPageTemplateFilesAsXML">
    <xsl:apply-templates select="$GlobalPageTemplate" mode="wwmode:pagetemplate-files" />
   </xsl:variable>
   <xsl:variable name="VarPageTemplateFiles" select="msxsl:node-set($VarPageTemplateFilesAsXML)" />
   <xsl:variable name="VarPageTemplateFilesPaths">
    <xsl:for-each select="$VarPageTemplateFiles/wwpage:File">
     <xsl:value-of select="@path" />
     <xsl:value-of select="':'" />
    </xsl:for-each>
   </xsl:variable>
   <xsl:variable name="VarPageTemplateFilesChecksum" select="wwstring:MD5Checksum($VarPageTemplateFilesPaths)" />

   <!-- Iterate input documents -->
   <!--                         -->
   <xsl:for-each select="$GlobalFiles[1]">
    <xsl:variable name="VarFilesByType" select="key('wwfiles-files-by-type', $ParameterDependsType)" />

    <xsl:value-of select="wwprogress:Start(count($VarFilesByType))" />

    <xsl:for-each select="$VarFilesByType">
     <xsl:value-of select="wwprogress:Start(1)" />

     <xsl:variable name="VarFilesDocument" select="." />

     <!-- Load splits -->
     <!--             -->
     <xsl:variable name="VarFilesSplits" select="key('wwfiles-files-by-type', $ParameterSplitsType)[@groupID = $VarFilesDocument/@groupID][1]" />
     <xsl:variable name="VarSplits" select="wwexsldoc:LoadXMLWithoutResolver($VarFilesSplits/@path)" />

     <xsl:for-each select="$VarSplits[1]">
      <!-- Split -->
      <!--       -->
      <xsl:variable name="VarSplit" select="key('wwsplits-files-by-type', $ParameterParcelInfoSplitFileType)[@groupID = $VarFilesDocument/@groupID][1]" />

      <!-- Transform -->
      <!--           -->
      <xsl:variable name="VarUpToDate" select="wwfilesext:UpToDate($VarSplit/@path, $VarPageTemplateFilesChecksum, $VarFilesDocument/@groupID, $VarFilesDocument/@documentID, $GlobalActionChecksum)" />
      <xsl:if test="not($VarUpToDate)">
       <xsl:variable name="VarResultAsXML">
        <!-- Load document -->
        <!--               -->
        <xsl:variable name="VarTOC" select="wwexsldoc:LoadXMLWithoutResolver($VarFilesDocument/@path)" />

        <xsl:call-template name="Parcel">
         <xsl:with-param name="ParamSplits" select="$VarSplits" />
         <xsl:with-param name="ParamTOC" select="$VarTOC" />
         <xsl:with-param name="ParamSplit" select="$VarSplit" />
        </xsl:call-template>
       </xsl:variable>
       <xsl:variable name="VarResult" select="msxsl:node-set($VarResultAsXML)" />
       <xsl:variable name="VarPrettyPrint">
        <xsl:choose>
         <xsl:when test="wwprojext:GetFormatSetting('file-processing-pretty-print') = 'true'">
          <xsl:text>yes</xsl:text>
         </xsl:when>

         <xsl:otherwise>
          <xsl:text>no</xsl:text>
         </xsl:otherwise>
        </xsl:choose>
       </xsl:variable>
       <xsl:variable name="VarWriteResult" select="wwexsldoc:Document($VarResult, $VarSplit/@path, wwprojext:GetFormatSetting('encoding', 'utf-8'), 'html', '5.0', $VarPrettyPrint, 'yes', 'no', 'urn:WebWorks_DOCTYPE_ElementOnly', '')" />
      </xsl:if>

      <!-- Report Files -->
      <!--              -->
      <wwfiles:File path="{$VarSplit/@path}" type="{$ParameterType}" checksum="{wwfilesystem:GetChecksum($VarSplit/@path)}" projectchecksum="{$VarPageTemplateFilesChecksum}" groupID="{$VarFilesDocument/@groupID}" documentID="{$VarFilesDocument/@documentID}" actionchecksum="{$GlobalActionChecksum}" category="{$ParameterCategory}" use="{$ParameterUse}" deploy="{$ParameterDeploy}">
       <wwfiles:Depends path="{$GlobalLocalePath}" checksum="{wwfilesystem:GetChecksum($GlobalLocalePath)}" groupID="" documentID="" />
       <wwfiles:Depends path="{$GlobalLinksPath}" checksum="{wwfilesystem:GetChecksum($GlobalLinksPath)}" groupID="" documentID="" />
       <wwfiles:Depends path="{$GlobalMapEntrySetsPath}" checksum="{wwfilesystem:GetChecksum($GlobalMapEntrySetsPath)}" groupID="" documentID="" />
       <wwfiles:Depends path="{$GlobalPageTemplatePath}" checksum="{wwfilesystem:GetChecksum($GlobalPageTemplatePath)}" groupID="" documentID="" />
       <wwfiles:Depends path="{$GlobalProjectVariablesPath}" checksum="{wwfilesystem:GetChecksum($GlobalProjectVariablesPath)}" groupID="" documentID="" />
       <wwfiles:Depends path="{$VarFilesSplits/@path}" checksum="{$VarFilesSplits/@checksum}" groupID="{$VarFilesSplits/@groupID}" documentID="{$VarFilesSplits/@documentID}" />
       <wwfiles:Depends path="{$VarFilesDocument/@path}" checksum="{$VarFilesDocument/@checksum}" groupID="{$VarFilesDocument/@groupID}" documentID="{$VarFilesDocument/@documentID}" />

       <!-- Page Template Include Files -->
       <!--                             -->
       <xsl:for-each select="$GlobalPageTemplateIncludeFiles">
        <xsl:variable name="VarFile" select="." />

        <wwfiles:Depends path="{$VarFile/@path}" checksum="{wwfilesystem:GetChecksum($VarFile/@path)}" groupID="" documentID="" />
       </xsl:for-each>
      </wwfiles:File>

      <!-- Page Template Files -->
      <!--                     -->
      <xsl:variable name="VarOutputDirectoryPath" select="wwfilesystem:GetDirectoryName($VarSplit/@path)" />
      <xsl:for-each select="$VarPageTemplateFiles/wwpage:File">
       <xsl:variable name="VarPageTemplateFile" select="." />

       <!-- Get source and destination paths -->
       <!--                                  -->
       <xsl:variable name="VarSourcePath" select="wwuri:AsFilePath(concat('wwformat:Pages/', $VarPageTemplateFile/@path))" />
       <xsl:variable name="VarDestinationPath" select="wwfilesystem:Combine($VarOutputDirectoryPath, $VarPageTemplateFile/@path)" />
     
       <!-- Copy -->
       <!--      -->
       <xsl:variable name="VarPageTemplateFileUpToDate" select="wwfilesext:UpToDate($VarDestinationPath, '', '', '', concat($GlobalActionChecksum, ':', $VarSourcePath))" />
       <xsl:if test="not($VarPageTemplateFileUpToDate)">
        <xsl:variable name="VarIgnore" select="wwfilesystem:CopyFile($VarSourcePath, $VarDestinationPath)" />
       </xsl:if>

       <!-- Report Files -->
       <!--              -->
       <wwfiles:File path="{$VarDestinationPath}" type="{$ParameterType}" checksum="{wwfilesystem:GetChecksum($VarDestinationPath)}" projectchecksum="" groupID="" documentID="" actionchecksum="{concat($GlobalActionChecksum, ':', $VarSourcePath)}" category="{$ParameterCategory}" use="{$ParameterUse}" deploy="{$ParameterDeploy}">
        <wwfiles:Depends path="{$VarSourcePath}" checksum="{wwfilesystem:GetChecksum($VarSourcePath)}" groupID="" documentID="" />
       </wwfiles:File>
      </xsl:for-each>
     </xsl:for-each>

     <xsl:value-of select="wwprogress:End()" />
    </xsl:for-each>

    <xsl:value-of select="wwprogress:End()" />
   </xsl:for-each>

  </wwfiles:Files>
 </xsl:template>


 <xsl:template name="Parcel">
  <xsl:param name="ParamSplits" />
  <xsl:param name="ParamTOC" />
  <xsl:param name="ParamSplit" />

  <!-- Page Rule -->
  <!--           -->
  <xsl:variable name="VarPageRule" select="wwprojext:GetRule('Page', $ParamSplit/@stylename)" />

  <!-- Split files -->
  <!--             -->
  <xsl:for-each select="$ParamSplits[1]">
   <!-- Conditions -->
   <!--            -->
   <xsl:variable name="VarConditionsAsXML">
   </xsl:variable>
   <xsl:variable name="VarConditions" select="msxsl:node-set($VarConditionsAsXML)" />

   <!-- Replacements -->
   <!--              -->
   <xsl:variable name="VarReplacementsAsXML">
    <wwpage:Replacement name="title" value="{$ParamSplit/@title}" />

    <wwpage:Replacement name="locale" value="{wwprojext:GetFormatSetting('locale', 'en')}" />
    <wwpage:Replacement name="content-type" value="{concat('text/html;charset=', wwprojext:GetFormatSetting('encoding', 'utf-8'))}" />

    <!-- toc-id -->
    <!--        -->
    <wwpage:Replacement name="toc-id" value="toc:{$ParamSplit/@groupID}" />

    <!-- topics-id -->
    <!--           -->
    <wwpage:Replacement name="data-id" value="data:{$ParamSplit/@groupID}" />

    <!-- TOC -->
    <!--     -->
    <wwpage:Replacement name="toc">
     <xsl:apply-templates select="$ParamTOC" mode="wwmode:toc">
      <xsl:with-param name="ParamSplit" select="$ParamSplit" />
     </xsl:apply-templates>
    </wwpage:Replacement>
    
    <!-- Prev/Next -->
    <!--           -->
    <wwpage:Replacement name="prev-next">
     <xsl:variable name="VarFirstSplit" select="$ParamSplits/wwsplits:Splits/wwsplits:Split[1]" />
     <xsl:variable name="VarLastSplit" select="$ParamSplits/wwsplits:Splits/wwsplits:Split[last()]" />

     <!-- First page body-id -->
     <!--                    -->
     <xsl:variable name="VarFirstPageIDComponents">
      <xsl:value-of select="$VarFirstSplit/@groupID" />
      <xsl:text>:</xsl:text>
      <xsl:value-of select="$VarFirstSplit/@documentID" />
      <xsl:text>:</xsl:text>
      <xsl:value-of select="$VarFirstSplit/@path" />
     </xsl:variable>
     <xsl:variable name="VarFirstPageID" select="wwstring:NCNAME(translate(wwstring:MD5Checksum($VarFirstPageIDComponents), '=', ''))" />

     <!-- Last page body-id -->
     <!--                   -->
     <xsl:variable name="VarLastPageIDComponents">
      <xsl:value-of select="$VarLastSplit/@groupID" />
      <xsl:text>:</xsl:text>
      <xsl:value-of select="$VarLastSplit/@documentID" />
      <xsl:text>:</xsl:text>
      <xsl:value-of select="$VarLastSplit/@path" />
     </xsl:variable>
     <xsl:variable name="VarLastPageID" select="wwstring:NCNAME(translate(wwstring:MD5Checksum($VarLastPageIDComponents), '=', ''))" />

     <xsl:variable name="VarFirstHref">
      <xsl:call-template name="Connect-URI-GetRelativeTo">
       <xsl:with-param name="ParamDestinationURI" select="$ParamSplits/wwsplits:Splits/wwsplits:Split[1]/@path" />
       <xsl:with-param name="ParamSourceURI" select="$ParamSplit/@path" />
      </xsl:call-template>
     </xsl:variable>
      
     <xsl:variable name="VarLastHref">
      <xsl:call-template name="Connect-URI-GetRelativeTo">
       <xsl:with-param name="ParamDestinationURI" select="$ParamSplits/wwsplits:Splits/wwsplits:Split[last()]/@path" />
       <xsl:with-param name="ParamSourceURI" select="$ParamSplit/@path" />
      </xsl:call-template>
     </xsl:variable>

     <html:div id="page:{$ParamSplit/@groupID}:first"><html:a id="p{$VarFirstPageID}:first" href="{$VarFirstHref}"><xsl:value-of select="$ParamSplits/wwsplits:Splits/wwsplits:Split[1]/@title" /></html:a></html:div>
     <html:div id="page:{$ParamSplit/@groupID}:last"><html:a id="p{$VarLastPageID}:last" href="{$VarLastHref}"><xsl:value-of select="$ParamSplits/wwsplits:Splits/wwsplits:Split[last()]/@title" /></html:a></html:div>
    </wwpage:Replacement>

    <!-- Topics -->
    <!--        -->
    <wwpage:Replacement name="topics">
     <xsl:apply-templates select="$GlobalLinks" mode="wwmode:topics">
      <xsl:with-param name="ParamParcelPath" select="$ParamSplit/@path" />
      <xsl:with-param name="ParamGroupID" select="$ParamSplit/@groupID" />
     </xsl:apply-templates>
    </wwpage:Replacement>

    <!-- Variables -->
    <!--           -->
    <xsl:variable name="VarPageVariablesAsXML">
     <xsl:for-each select="$GlobalProjectVariables[1]">
      <xsl:variable name="VarVariablesGroup" select="key('wwvars-groups-by-groupid', $ParamSplit/@groupID)[1]" />

      <xsl:call-template name="Variables-Filter-Last-Unique">
       <xsl:with-param name="ParamVariables" select="$VarVariablesGroup//wwvars:Variable" />
      </xsl:call-template>
     </xsl:for-each>
    </xsl:variable>
    <xsl:variable name="VarPageVariables" select="msxsl:node-set($VarPageVariablesAsXML)/wwvars:Variable" />
    <xsl:call-template name="Variables-Page-String-Replacements">
     <xsl:with-param name="ParamVariables" select="$VarPageVariables" />
    </xsl:call-template>
   </xsl:variable>
   <xsl:variable name="VarReplacements" select="msxsl:node-set($VarReplacementsAsXML)" />

   <!-- Map common characters -->
   <!--                       -->
   <wwexsldoc:MappingContext>
    <xsl:copy-of select="$GlobalMapEntrySets/wwexsldoc:MapEntrySets/wwexsldoc:MapEntrySet[@name = 'common']/wwexsldoc:MapEntry" />

    <!-- Invoke page template -->
    <!--                      -->
    <xsl:apply-templates select="$GlobalPageTemplate" mode="wwmode:pagetemplate">
     <xsl:with-param name="ParamPageTemplateURI" select="$ParameterPageTemplateURI" />
     <xsl:with-param name="ParamOutputDirectoryPath" select="wwfilesystem:Combine(wwprojext:GetTargetOutputDirectoryPath(), wwstring:ReplaceWithExpression(wwstring:Replace(wwprojext:GetGroupName($ParamSplit/@groupID), $GlobalFilenameSpacesToUnderscoresSearchString, $GlobalFilenameSpacesToUnderscoresReplaceString), $GlobalInvalidPathCharactersExpression, '_'))" />
     <xsl:with-param name="ParamOutputPath" select="$ParamSplit/@path" />
     <xsl:with-param name="ParamConditions" select="$VarConditions" />
     <xsl:with-param name="ParamReplacements" select="$VarReplacements" />
    </xsl:apply-templates>
   </wwexsldoc:MappingContext>
  </xsl:for-each>
 </xsl:template>


 <xsl:template name="Paragraph">
  <xsl:param name="ParamParagraph" />

  <xsl:variable name="VarText">
   <xsl:for-each select="$ParamParagraph/wwdoc:Number/wwdoc:Text | $ParamParagraph/wwdoc:TextRun/wwdoc:Text">
    <xsl:value-of select="@value" />
   </xsl:for-each>
  </xsl:variable>
  <xsl:value-of select="normalize-space($VarText)" />
 </xsl:template>


 <!-- wwmode:toc -->
 <!--            -->

 <xsl:template match="/" mode="wwmode:toc">
  <xsl:param name="ParamSplit" />

  <xsl:apply-templates mode="wwmode:toc">
   <xsl:with-param name="ParamSplit" select="$ParamSplit" />
  </xsl:apply-templates>
 </xsl:template>


 <xsl:template match="wwtoc:TableOfContents" mode="wwmode:toc">
  <xsl:param name="ParamSplit" />

  <!-- Process child entries -->
  <!--                       -->
  <xsl:if test="count(./wwtoc:Entry[1]) = 1">
   <html:ul>
    <xsl:apply-templates mode="wwmode:toc">
     <xsl:with-param name="ParamSplit" select="$ParamSplit" />
    </xsl:apply-templates>
   </html:ul>
  </xsl:if>
 </xsl:template>


 <xsl:template match="wwtoc:Entry" mode="wwmode:toc">
  <xsl:param name="ParamEntry" select="." />
  <xsl:param name="ParamSplit" />

  <!-- Has child entries? -->
  <!--                    -->
  <xsl:variable name="VarHasChildEntries" select="count(./wwtoc:Entry[1]) = 1" />
  <xsl:variable name="VarHasLink" select="string-length($ParamEntry/@path) &gt; 0" />

  <html:li>
   <html:div>
    <!-- Determine page ID -->
    <!--                   -->
    <xsl:variable name="VarPageIDComponents">
     <xsl:value-of select="$ParamSplit/@groupID" />
     <xsl:text>:</xsl:text>
     <xsl:value-of select="$ParamEntry/@documentID" />
     <xsl:text>:</xsl:text>
     <xsl:value-of select="$ParamEntry/@path" />
    </xsl:variable>
    <xsl:variable name="VarPageID" select="wwstring:NCNAME(translate(wwstring:MD5Checksum($VarPageIDComponents), '=', ''))" />

    <!-- Identify first TOC link to a page -->
    <!--                                   -->
    <xsl:for-each select="$ParamEntry">
     <xsl:variable name="VarFirstLinkToPage" select="count(key('wwtoc-entries-by-path', $ParamEntry/@path)[1] | $ParamEntry ) = 1" />
     <xsl:if test="$VarFirstLinkToPage">
      <xsl:attribute name="id">
       <xsl:text>p</xsl:text>
       <xsl:value-of select="$VarPageID" />
      </xsl:attribute>
     </xsl:if>
    </xsl:for-each>

    <!-- Folder or document? -->
    <!--                     -->
    <xsl:attribute name="class">
     <xsl:text>ww_skin_toc_entry</xsl:text>
     <xsl:if test="$VarHasChildEntries">
      <xsl:text> ww_skin_toc_folder</xsl:text>
     </xsl:if>
    </xsl:attribute>

    <!-- No break -->
    <!--          -->
    <wwexsldoc:NoBreak />

    <!-- Expand/collapse -->
    <!--                 -->
    <xsl:if test="$VarHasChildEntries">
     <html:span class="ww_skin ww_skin_toc_dropdown ww_skin_toc_dropdown_closed">
      <xsl:text>&#160;</xsl:text>
     </html:span>
    </xsl:if>

    <!-- Entry -->
    <!--       -->
    <xsl:choose>
     <xsl:when test="$VarHasLink">
      <!-- Determine TOC Entry ID -->
      <!--                        -->
      <xsl:variable name="VarTOCEntryID">
       <xsl:text>p</xsl:text>
       <xsl:value-of select="$VarPageID" />
       <xsl:text>:</xsl:text>
       <xsl:text>ww</xsl:text>
       <xsl:value-of select="$ParamEntry/@linkid" />
      </xsl:variable>

      <!-- Get link -->
      <!--          -->
      <xsl:variable name="VarRelativeLinkPath">
       <xsl:call-template name="Connect-URI-GetRelativeTo">
        <xsl:with-param name="ParamDestinationURI" select="$ParamEntry/@path" />
        <xsl:with-param name="ParamSourceURI" select="$ParamSplit/@path" />
       </xsl:call-template>
      </xsl:variable>

      <html:a id="{$VarTOCEntryID}" class="WebWorks_TOC_Link">
       <xsl:attribute name="href">
        <xsl:value-of select="$VarRelativeLinkPath" />
        <xsl:if test="$ParamEntry/@first != 'true'">
         <xsl:text>#</xsl:text>
         <xsl:text>ww</xsl:text>
         <xsl:value-of select="$ParamEntry/@linkid" />
        </xsl:if>
       </xsl:attribute>

       <xsl:call-template name="Paragraph">
        <xsl:with-param name="ParamParagraph" select="$ParamEntry/wwdoc:Paragraph" />
       </xsl:call-template>
      </html:a>
     </xsl:when>

     <xsl:otherwise>
      <xsl:call-template name="Paragraph">
       <xsl:with-param name="ParamParagraph" select="$ParamEntry/wwdoc:Paragraph" />
      </xsl:call-template>
     </xsl:otherwise>
    </xsl:choose>
   </html:div>

   <!-- Process child entries -->
   <!--                       -->
   <xsl:if test="$VarHasChildEntries">
    <html:ul>
     <xsl:apply-templates mode="wwmode:toc">
      <xsl:with-param name="ParamSplit" select="$ParamSplit" />
     </xsl:apply-templates>
    </html:ul>
   </xsl:if>
  </html:li>
 </xsl:template>


 <xsl:template match="*" mode="wwmode:toc">
  <xsl:param name="ParamSplit" />

  <!-- Process child entries -->
  <!--                       -->
  <xsl:apply-templates mode="wwmode:toc">
   <xsl:with-param name="ParamSplit" select="$ParamSplit" />
  </xsl:apply-templates>
 </xsl:template>


 <xsl:template match="text() | comment() | processing-instruction()" mode="wwmode:toc">
  <xsl:param name="ParamSplit" />

  <!-- Ignore -->
  <!--        -->
 </xsl:template>


 <!-- wwmode:topics -->
 <!--               -->

 <xsl:template match="/" mode="wwmode:topics">
  <xsl:param name="ParamParcelPath" />
  <xsl:param name="ParamGroupID" />

  <!-- Process children -->
  <!--                  -->
  <xsl:apply-templates mode="wwmode:topics">
   <xsl:with-param name="ParamParcelPath" select="$ParamParcelPath" />
   <xsl:with-param name="ParamGroupID" select="$ParamGroupID" />
  </xsl:apply-templates>
 </xsl:template>


 <xsl:template match="wwlinks:File" mode="wwmode:topics">
  <xsl:param name="ParamParcelPath" />
  <xsl:param name="ParamGroupID" />
  <xsl:param name="ParamLinkFile" select="." />

  <!-- Matches group? -->
  <!--                -->
  <xsl:if test="$ParamLinkFile/@groupID = $ParamGroupID">
   <!-- Process children -->
   <!--                  -->
   <xsl:apply-templates mode="wwmode:topics-paragraph">
    <xsl:with-param name="ParamParcelPath" select="$ParamParcelPath" />
    <xsl:with-param name="ParamGroupID" select="$ParamGroupID" />
    <xsl:with-param name="ParamLinkFile" select="$ParamLinkFile" />
   </xsl:apply-templates>
  </xsl:if>
 </xsl:template>


 <xsl:template match="*" mode="wwmode:topics">
  <xsl:param name="ParamParcelPath" />
  <xsl:param name="ParamGroupID" />

  <!-- Process children -->
  <!--                  -->
  <xsl:apply-templates mode="wwmode:topics">
   <xsl:with-param name="ParamParcelPath" select="$ParamParcelPath" />
   <xsl:with-param name="ParamGroupID" select="$ParamGroupID" />
  </xsl:apply-templates>
 </xsl:template>


 <xsl:template match="text() | comment() | processing-instruction()" mode="wwmode:topics">
  <xsl:param name="ParamParcelPath" />
  <xsl:param name="ParamGroupID" />

  <!-- Ignore -->
  <!--        -->
 </xsl:template>


 <!-- wwmode:topics-paragraph -->
 <!--                         -->

 <xsl:template match="/" mode="wwmode:topics-paragraph">
  <xsl:param name="ParamParcelPath" />
  <xsl:param name="ParamGroupID" />
  <xsl:param name="ParamLinkFile" />

  <!-- Process children -->
  <!--                  -->
  <xsl:apply-templates mode="wwmode:topics-paragraph">
   <xsl:with-param name="ParamParcelPath" select="$ParamParcelPath" />
   <xsl:with-param name="ParamGroupID" select="$ParamGroupID" />
   <xsl:with-param name="ParamLinkFile" select="$ParamLinkFile" />
  </xsl:apply-templates>
 </xsl:template>


 <xsl:template match="wwlinks:Paragraph" mode="wwmode:topics-paragraph">
  <xsl:param name="ParamParcelPath" />
  <xsl:param name="ParamGroupID" />
  <xsl:param name="ParamLinkFile" />
  <xsl:param name="ParamLinkParagraph" select="." />

  <!-- Topic? -->
  <!--        -->
  <xsl:if test="string-length($ParamLinkParagraph/@topic) &gt; 0">
   <!-- Resolve link -->
   <!--              -->
   <xsl:variable name="VarHREF">
    <xsl:value-of select="wwuri:GetRelativeTo($ParamLinkFile/@path, $ParamParcelPath)" />
    <xsl:if test="$ParamLinkParagraph/@first = 'false'">
     <xsl:text>#</xsl:text>
     <xsl:value-of select="$ParamLinkParagraph/@linkid" />
    </xsl:if>
   </xsl:variable>

   <!-- Emit topic -->
   <!--            -->
   <html:div>
    <html:a id="topic:{$ParamGroupID}:{wwstring:WebWorksHelpContextOrTopic($ParamLinkParagraph/@topic)}" href="{$VarHREF}"><xsl:value-of select="$ParamLinkParagraph/@topic" /></html:a>
   </html:div>
  </xsl:if>

  <!-- Process children -->
  <!--                  -->
  <xsl:apply-templates mode="wwmode:topics-paragraph">
   <xsl:with-param name="ParamParcelPath" select="$ParamParcelPath" />
   <xsl:with-param name="ParamGroupID" select="$ParamGroupID" />
   <xsl:with-param name="ParamLinkFile" select="$ParamLinkFile" />
  </xsl:apply-templates>
 </xsl:template>


 <xsl:template match="*" mode="wwmode:topics-paragraph">
  <xsl:param name="ParamParcelPath" />
  <xsl:param name="ParamGroupID" />
  <xsl:param name="ParamLinkFile" />

  <!-- Process children -->
  <!--                  -->
  <xsl:apply-templates mode="wwmode:topics-paragraph">
   <xsl:with-param name="ParamParcelPath" select="$ParamParcelPath" />
   <xsl:with-param name="ParamGroupID" select="$ParamGroupID" />
   <xsl:with-param name="ParamLinkFile" select="$ParamLinkFile" />
  </xsl:apply-templates>
 </xsl:template>


 <xsl:template match="text() | comment() | processing-instruction()" mode="wwmode:topics-paragraph">
  <xsl:param name="ParamParcelPath" />
  <xsl:param name="ParamGroupID" />
  <xsl:param name="ParamLinkFile" />

  <!-- Ignore -->
  <!--        -->
 </xsl:template>
</xsl:stylesheet>
